<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'name_ar', 'is_active');

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function users()
    {
        return $this->hasMany('App\Models\User');
    }

    public function districts()
    {
        return $this->hasMany('App\Models\District');
    }

}